---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ドキュメント (_document)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/pages/_document.tsx` L962-984 - Documentクラス定義
- E-02: `packages/next/src/pages/_document.tsx` L372-733 - Headクラス定義
- E-03: `packages/next/src/pages/_document.tsx` L792-923 - NextScriptクラス定義
- E-04: `packages/next/src/pages/_document.tsx` L925-949 - Htmlコンポーネント
- E-05: `packages/next/src/pages/_document.tsx` L951-956 - Mainコンポーネント
- E-06: `packages/next/src/pages/_document.tsx` L54-66 - getDocumentFiles関数
- E-07: `packages/next/src/pages/_document.tsx` L68-95 - getPolyfillScripts関数
- E-08: `packages/next/src/pages/_document.tsx` L164-269 - getPreNextWorkerScripts関数
- E-09: `packages/next/src/pages/_document.tsx` L311-364 - getNextFontLinkTags関数
- E-10: `packages/next/src/pages/_document.tsx` L735-790 - handleDocumentScriptLoaderItems関数
- E-11: `packages/next/src/pages/_document.tsx` L813-857 - getInlineScriptSource静的メソッド
- E-12: `packages/next/src/pages/_document.tsx` L988-1000 - InternalFunctionDocument
- E-13: `packages/next/src/pages/_document.tsx` L669-685 - FOUC防止スタイル
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv` L3 - 画面情報定義
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L5-9 - 関連機能情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLドキュメントの基本構造(html,head,body)を定義する | E-01 | ○ |
| C-02 | サーバーサイドでのみレンダリングされる | E-14 | ○ |
| C-03 | Headコンポーネントがcss/js/fontのlink/scriptタグを生成 | E-02 | ○ |
| C-04 | CSSファイルのpreload/stylesheet読み込み管理 | E-02 | ○ |
| C-05 | 動的インポートチャンクのpreloadリンク生成 | E-02 | ○ |
| C-06 | polyfillスクリプトのnomodule読み込み | E-07 | ○ |
| C-07 | beforeInteractiveスクリプトの読み込み制御 | E-08, E-10 | ○ |
| C-08 | Partytown Workerスクリプト対応 | E-08 | ○ |
| C-09 | Next Fontマニフェストに基づくフォントpreload/preconnect | E-09 | ○ |
| C-10 | Mainコンポーネントがnext-js-internal-body-render-targetを出力 | E-05 | ○ |
| C-11 | NextScriptが__NEXT_DATA__をJSON形式で出力 | E-03, E-11 | ○ |
| C-12 | NEXT_BUILTIN_DOCUMENTでビルトインDocumentを識別 | E-12 | ○ |
| C-13 | FOUC防止のためbody{display:none}を開発環境で挿入 | E-13 | ○ |
| C-14 | __NEXT_DATA__のサイズ超過時に警告出力 | E-11 | ○ |
| C-15 | 循環参照時にエラーをスロー | E-11 | ○ |
| C-16 | Head内title使用時の開発環境警告 | E-02 | ○ |
| C-17 | Head内viewport meta使用時の開発環境警告 | E-02 | ○ |
| C-18 | crossOrigin属性の非推奨警告 | E-02, E-03 | ○ |
| C-19 | optimizeCssオプションでpreload省略 | E-02 | ○ |
| C-20 | HtmlコンポーネントがlocaleとdeploymentIdを設定 | E-04 | ○ |
| C-21 | handleDocumentScriptLoaderItemsがscript要素を分類 | E-10 | ○ |
| C-22 | InternalFunctionDocumentが内部的に使用される | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Head.renderの出力順序が正確に記載されているか確認
- [ ] スクリプトローディング戦略（optimizedLoading/disabledOptimizedLoading）の記述が正確か確認
- [ ] 開発環境固有の警告メッセージが網羅されているか確認
